/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.widget.Scroller;
import java.util.HashMap;
import java.util.Map;
import org.vudroid.core.DecodeService;
import org.vudroid.core.Page;
import org.vudroid.core.events.ZoomListener;
import org.vudroid.core.models.CurrentPageModel;
import org.vudroid.core.models.DecodingProgressModel;
import org.vudroid.core.models.ZoomModel;
import org.vudroid.core.multitouch.MultiTouchZoom;

public class DocumentView
extends View
implements ZoomListener {
    final ZoomModel zoomModel;
    private final CurrentPageModel currentPageModel;
    DecodeService decodeService;
    private final HashMap<Integer, Page> pages = new HashMap();
    private boolean isInitialized = false;
    private int pageToGoTo;
    private float lastX;
    private float lastY;
    private VelocityTracker velocityTracker;
    private final Scroller scroller;
    DecodingProgressModel progressModel;
    private RectF viewRect;
    private boolean inZoom;
    private long lastDownEventTime;
    private static final int DOUBLE_TAP_TIME = 500;
    private MultiTouchZoom multiTouchZoom;

    public DocumentView(Context context, ZoomModel zoomModel, DecodingProgressModel progressModel, CurrentPageModel currentPageModel) {
        super(context);
        this.zoomModel = zoomModel;
        this.progressModel = progressModel;
        this.currentPageModel = currentPageModel;
        this.setKeepScreenOn(true);
        this.scroller = new Scroller(this.getContext());
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.initMultiTouchZoomIfAvailable(zoomModel);
    }

    private void initMultiTouchZoomIfAvailable(ZoomModel zoomModel) {
        try {
            this.multiTouchZoom = (MultiTouchZoom)Class.forName("org.vudroid.core.multitouch.MultiTouchZoomImpl").getConstructor(ZoomModel.class).newInstance(zoomModel);
        }
        catch (Exception e) {
            System.out.println("Multi touch zoom is not available: " + e);
        }
    }

    public void setDecodeService(DecodeService decodeService) {
        this.decodeService = decodeService;
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        int width = this.decodeService.getEffectivePagesWidth();
        int height = this.decodeService.getEffectivePagesHeight();
        int i = 0;
        while (i < this.decodeService.getPageCount()) {
            this.pages.put(i, new Page(this, i));
            this.pages.get(i).setAspectRatio(width, height);
            ++i;
        }
        this.isInitialized = true;
        this.invalidatePageSizes();
        this.goToPageImpl(this.pageToGoTo);
    }

    private void goToPageImpl(int toPage) {
        this.scrollTo(0, this.pages.get(toPage).getTop());
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.post(new Runnable(){

            @Override
            public void run() {
                DocumentView.this.currentPageModel.setCurrentPageIndex(DocumentView.this.getCurrentPage());
            }
        });
        if (this.inZoom) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                DocumentView.this.updatePageVisibility();
            }
        });
    }

    private void updatePageVisibility() {
        for (Page page : this.pages.values()) {
            page.updateVisibility();
        }
    }

    @Override
    public void commitZoom() {
        for (Page page : this.pages.values()) {
            page.invalidate();
        }
        this.inZoom = false;
    }

    public void showDocument() {
        this.post(new Runnable(){

            @Override
            public void run() {
                DocumentView.this.init();
                DocumentView.this.updatePageVisibility();
            }
        });
    }

    public void goToPage(int toPage) {
        if (this.isInitialized) {
            this.goToPageImpl(toPage);
        } else {
            this.pageToGoTo = toPage;
        }
    }

    public int getCurrentPage() {
        for (Map.Entry<Integer, Page> entry : this.pages.entrySet()) {
            if (!entry.getValue().isVisible()) continue;
            return entry.getKey();
        }
        return 0;
    }

    @Override
    public void zoomChanged(float newZoom, float oldZoom) {
        this.inZoom = true;
        this.stopScroller();
        float ratio = newZoom / oldZoom;
        this.invalidatePageSizes();
        this.scrollTo((int)((float)(this.getScrollX() + this.getWidth() / 2) * ratio - (float)(this.getWidth() / 2)), (int)((float)(this.getScrollY() + this.getHeight() / 2) * ratio - (float)(this.getHeight() / 2)));
        this.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (this.multiTouchZoom != null) {
            if (this.multiTouchZoom.onTouchEvent(ev)) {
                return true;
            }
            if (this.multiTouchZoom.isResetLastPointAfterZoom()) {
                this.setLastPosition(ev);
                this.multiTouchZoom.setResetLastPointAfterZoom(false);
            }
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(ev);
        switch (ev.getAction()) {
            case 0: {
                this.stopScroller();
                this.setLastPosition(ev);
                if (ev.getEventTime() - this.lastDownEventTime < 500L) {
                    this.zoomModel.toggleZoomControls();
                    break;
                }
                this.lastDownEventTime = ev.getEventTime();
                break;
            }
            case 2: {
                this.scrollBy((int)(this.lastX - ev.getX()), (int)(this.lastY - ev.getY()));
                this.setLastPosition(ev);
                break;
            }
            case 1: {
                this.velocityTracker.computeCurrentVelocity(1000);
                this.scroller.fling(this.getScrollX(), this.getScrollY(), (int)(-this.velocityTracker.getXVelocity()), (int)(-this.velocityTracker.getYVelocity()), this.getLeftLimit(), this.getRightLimit(), this.getTopLimit(), this.getBottomLimit());
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
        return true;
    }

    private void setLastPosition(MotionEvent ev) {
        this.lastX = ev.getX();
        this.lastY = ev.getY();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 22: {
                    this.lineByLineMoveTo(1);
                    return true;
                }
                case 21: {
                    this.lineByLineMoveTo(-1);
                    return true;
                }
                case 20: {
                    this.verticalDpadScroll(1);
                    return true;
                }
                case 19: {
                    this.verticalDpadScroll(-1);
                    return true;
                }
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private void verticalDpadScroll(int direction) {
        this.scroller.startScroll(this.getScrollX(), this.getScrollY(), 0, direction * this.getHeight() / 2);
        this.invalidate();
    }

    private void lineByLineMoveTo(int direction) {
        if (direction == 1 ? this.getScrollX() == this.getRightLimit() : this.getScrollX() == this.getLeftLimit()) {
            this.scroller.startScroll(this.getScrollX(), this.getScrollY(), direction * (this.getLeftLimit() - this.getRightLimit()), (int)((float)direction * this.pages.get((Object)Integer.valueOf((int)this.getCurrentPage())).bounds.height() / 50.0f));
        } else {
            this.scroller.startScroll(this.getScrollX(), this.getScrollY(), direction * this.getWidth() / 2, 0);
        }
        this.invalidate();
    }

    private int getTopLimit() {
        return 0;
    }

    private int getLeftLimit() {
        return 0;
    }

    private int getBottomLimit() {
        return (int)this.pages.get((Object)Integer.valueOf((int)(this.pages.size() - 1))).bounds.bottom - this.getHeight();
    }

    private int getRightLimit() {
        return (int)((float)this.getWidth() * this.zoomModel.getZoom()) - this.getWidth();
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(Math.min(Math.max(x, this.getLeftLimit()), this.getRightLimit()), Math.min(Math.max(y, this.getTopLimit()), this.getBottomLimit()));
        this.viewRect = null;
    }

    RectF getViewRect() {
        if (this.viewRect == null) {
            this.viewRect = new RectF((float)this.getScrollX(), (float)this.getScrollY(), (float)(this.getScrollX() + this.getWidth()), (float)(this.getScrollY() + this.getHeight()));
        }
        return this.viewRect;
    }

    public void computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Page page : this.pages.values()) {
            page.draw(canvas);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        float scrollScaleRatio = this.getScrollScaleRatio();
        this.invalidatePageSizes();
        this.invalidateScroll(scrollScaleRatio);
        this.commitZoom();
    }

    void invalidatePageSizes() {
        if (!this.isInitialized) {
            return;
        }
        float heightAccum = 0.0f;
        int width = this.getWidth();
        float zoom = this.zoomModel.getZoom();
        int i = 0;
        while (i < this.pages.size()) {
            Page page = this.pages.get(i);
            float pageHeight = page.getPageHeight(width, zoom);
            page.setBounds(new RectF(0.0f, heightAccum, (float)width * zoom, heightAccum + pageHeight));
            heightAccum += pageHeight;
            ++i;
        }
    }

    private void invalidateScroll(float ratio) {
        if (!this.isInitialized) {
            return;
        }
        this.stopScroller();
        Page page = this.pages.get(0);
        if (page == null || page.bounds == null) {
            return;
        }
        this.scrollTo((int)((float)this.getScrollX() * ratio), (int)((float)this.getScrollY() * ratio));
    }

    private float getScrollScaleRatio() {
        Page page = this.pages.get(0);
        if (page == null || page.bounds == null) {
            return 0.0f;
        }
        float v = this.zoomModel.getZoom();
        return (float)this.getWidth() * v / page.bounds.width();
    }

    private void stopScroller() {
        if (!this.scroller.isFinished()) {
            this.scroller.abortAnimation();
        }
    }
}

