/*
 * Decompiled with CFR 0.152.
 */
package com.printsdk.utils;

import android.graphics.Bitmap;
import android.graphics.RectF;
import com.printsdk.utils.PdfOpener;
import java.io.File;
import java.io.IOException;
import org.vudroid.pdfdroid.codec.PdfContext;
import org.vudroid.pdfdroid.codec.PdfDocument;
import org.vudroid.pdfdroid.codec.PdfPage;

public class PrintUtils {
    private static int m_iCutHeight = 0;

    public static int[] getPdfPrintData(String strPath, int iPageNumber, int iPageImageWidth, int iPageImageHeight) {
        try {
            PdfContext pdfContext = new PdfContext();
            PdfDocument pdfDocument = (PdfDocument)pdfContext.openDocument(strPath);
            PdfPage pdfPage = (PdfPage)pdfDocument.getPage(iPageNumber - 1);
            RectF rf = new RectF();
            rf.bottom = 1.0f;
            rf.right = 1.0f;
            Bitmap bm = pdfPage.renderBitmap(iPageImageWidth, iPageImageHeight, rf);
            int[] dataPrint = PrintUtils.getPixelsByBitmap(bm);
            return dataPrint;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] getPdfPrintDataCut(String strPath, int iPageNumber, int iPageImageWidth, int iPageImageHeight) {
        try {
            int iCol;
            PdfContext pdfContext = new PdfContext();
            PdfDocument pdfDocument = (PdfDocument)pdfContext.openDocument(strPath);
            PdfPage pdfPage = (PdfPage)pdfDocument.getPage(iPageNumber - 1);
            RectF rf = new RectF();
            rf.bottom = 1.0f;
            rf.right = 1.0f;
            Bitmap bm = pdfPage.renderBitmap(iPageImageWidth, iPageImageHeight, rf);
            int[] dataPrint = PrintUtils.getPixelsByBitmap(bm);
            int iCutHeight = 0;
            int iCutRowBegin = -1;
            int iCutRowEnd = -1;
            int iIndex = 0;
            int iRow = 0;
            while (iRow < iPageImageHeight) {
                iCol = 0;
                while (iCol < iPageImageWidth) {
                    if (dataPrint[iRow * iPageImageWidth + iCol] != -1) {
                        iCutRowBegin = iRow;
                        break;
                    }
                    ++iCol;
                }
                if (iCutRowBegin != -1) break;
                ++iRow;
            }
            iRow = iPageImageHeight - 1;
            while (iRow >= 0) {
                iCol = 0;
                while (iCol < iPageImageWidth) {
                    if (dataPrint[iRow * iPageImageWidth + iCol] != -1) {
                        iCutRowEnd = iRow;
                        break;
                    }
                    ++iCol;
                }
                if (iCutRowEnd != -1) break;
                --iRow;
            }
            m_iCutHeight = iCutHeight = iCutRowEnd - iCutRowBegin;
            int iCutDataLen = iPageImageWidth * iCutHeight;
            int[] cutPixels = new int[iCutDataLen];
            int iRow2 = iCutRowBegin;
            while (iRow2 < iCutRowEnd) {
                int iCol2 = 0;
                while (iCol2 < iPageImageWidth) {
                    cutPixels[iIndex++] = dataPrint[iRow2 * iPageImageWidth + iCol2];
                    ++iCol2;
                }
                ++iRow2;
            }
            return cutPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            m_iCutHeight = 0;
            return null;
        }
    }

    private static int[] getPdfPrintDataCut_Ext(String strPath, int iPageNumber, int iPageImageWidth, int iPageImageHeight) {
        m_iCutHeight = 0;
        PdfOpener.init();
        PdfOpener pdfOpener = new PdfOpener();
        try {
            int iCol;
            pdfOpener.openPdf(new File(strPath), null);
            PdfOpener.sPageImageWidth = iPageImageWidth;
            PdfOpener.sPageImageHeight = iPageImageHeight;
            Bitmap bm = pdfOpener.getPdfPageImage(iPageNumber);
            int[] dataPrint = PrintUtils.getPixelsByBitmap(bm);
            int iCutHeight = 0;
            int iCutRowBegin = -1;
            int iCutRowEnd = -1;
            int iIndex = 0;
            int iRow = 0;
            while (iRow < iPageImageHeight) {
                iCol = 0;
                while (iCol < iPageImageWidth) {
                    if (dataPrint[iRow * iPageImageWidth + iCol] != -1) {
                        iCutRowBegin = iRow;
                        break;
                    }
                    ++iCol;
                }
                if (iCutRowBegin != -1) break;
                ++iRow;
            }
            iRow = iPageImageHeight - 1;
            while (iRow >= 0) {
                iCol = 0;
                while (iCol < iPageImageWidth) {
                    if (dataPrint[iRow * iPageImageWidth + iCol] != -1) {
                        iCutRowEnd = iRow;
                        break;
                    }
                    ++iCol;
                }
                if (iCutRowEnd != -1) break;
                --iRow;
            }
            m_iCutHeight = iCutHeight = iCutRowEnd - iCutRowBegin;
            int iCutDataLen = iPageImageWidth * iCutHeight;
            int[] cutPixels = new int[iCutDataLen];
            int iRow2 = iCutRowBegin;
            while (iRow2 < iCutRowEnd) {
                int iCol2 = 0;
                while (iCol2 < iPageImageWidth) {
                    cutPixels[iIndex++] = dataPrint[iRow2 * iPageImageWidth + iCol2];
                    ++iCol2;
                }
                ++iRow2;
            }
            return cutPixels;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getCutHeight() {
        return m_iCutHeight;
    }

    public static int[] getPixelsByBitmap(Bitmap bm) {
        int width = bm.getWidth();
        int heigh = bm.getHeight();
        int iDataLen = width * heigh;
        int[] pixels = new int[iDataLen];
        bm.getPixels(pixels, 0, width, 0, 0, width, heigh);
        return pixels;
    }

    public static byte[] PrintMarkcutpaper() {
        byte[] bCmd = new byte[4];
        int iIndex = 0;
        bCmd[iIndex++] = 29;
        bCmd[iIndex++] = 86;
        bCmd[iIndex++] = 66;
        bCmd[iIndex++] = 0;
        return bCmd;
    }

    public static byte[] PrintMarkcutpaper_CS() {
        byte[] bCmd = new byte[6];
        int iIndex = 0;
        bCmd[iIndex++] = 29;
        bCmd[iIndex++] = 86;
        bCmd[iIndex++] = 66;
        bCmd[iIndex++] = 0;
        bCmd[iIndex++] = 0;
        bCmd[iIndex++] = -75;
        return bCmd;
    }

    public static byte[] PrintFeedForward(int iValue) {
        byte[] bCmd = new byte[3];
        int iIndex = 0;
        bCmd[iIndex++] = 27;
        bCmd[iIndex++] = 74;
        int i1 = (int)((double)(iValue * 10) / 1.25);
        if (i1 < 0) {
            i1 = 0;
        } else if (i1 > 240) {
            i1 = 240;
        }
        bCmd[iIndex++] = (byte)i1;
        return bCmd;
    }

    public static byte[] PrintFeedForward_CS(int iValue) {
        byte[] bCmd = new byte[5];
        int iIndex = 0;
        bCmd[iIndex++] = 27;
        bCmd[iIndex++] = 74;
        int i1 = (int)((double)(iValue * 10) / 1.25);
        if (i1 < 0) {
            i1 = 0;
        } else if (i1 > 240) {
            i1 = 240;
        }
        bCmd[iIndex++] = (byte)i1;
        int i2 = i1 + 27 + 74;
        bCmd[iIndex++] = (byte)(i2 >> 8);
        bCmd[iIndex++] = (byte)(i2 % 256);
        return bCmd;
    }

    public static byte[] PrintFeedBack(int iValue) {
        byte[] bCmd = new byte[3];
        int iIndex = 0;
        bCmd[iIndex++] = 27;
        bCmd[iIndex++] = 75;
        int i1 = (int)((double)(iValue * 10) / 1.25);
        if (i1 < 0) {
            i1 = 0;
        } else if (i1 > 240) {
            i1 = 240;
        }
        bCmd[iIndex++] = (byte)i1;
        return bCmd;
    }

    public static int CheckStatus_TS(byte[] b_recv) {
        if ((b_recv[1] & 4) == 4) {
            return 103;
        }
        if ((b_recv[3] & 0x60) == 96) {
            return 105;
        }
        if ((b_recv[2] & 4) == 4) {
            return 107;
        }
        if ((b_recv[2] & 8) == 8) {
            return 108;
        }
        if ((b_recv[2] & 0x40) == 64) {
            return 109;
        }
        if ((b_recv[3] & 1) == 1) {
            return 110;
        }
        if ((b_recv[3] & 0x80) == 128) {
            return 112;
        }
        if ((b_recv[3] & 0xC) == 12) {
            return 111;
        }
        if ((b_recv[0] & 0x40) == 64) {
            return 102;
        }
        return 0;
    }

    public static int CheckStatus1_TS(byte bRecv) {
        if ((bRecv & 8) == 8) {
            return 101;
        }
        if ((bRecv & 0x40) == 64) {
            return 102;
        }
        return 0;
    }

    public static int CheckStatus2_TS(byte bRecv) {
        if ((bRecv & 4) == 4) {
            return 103;
        }
        if ((bRecv & 8) == 8) {
            return 104;
        }
        if ((bRecv & 0x20) == 32) {
            return 105;
        }
        if ((bRecv & 0x40) == 64) {
            return 106;
        }
        return 0;
    }

    public static int CheckStatus3_TS(byte bRecv) {
        if ((bRecv & 4) == 4) {
            return 107;
        }
        if ((bRecv & 8) == 8) {
            return 108;
        }
        if ((bRecv & 0x40) == 64) {
            return 109;
        }
        return 0;
    }

    public static int CheckStatus4_TS(byte bRecv) {
        if ((bRecv & 1) == 1) {
            return 110;
        }
        if ((bRecv & 0xC) == 12) {
            return 111;
        }
        if ((bRecv & 0x60) == 96) {
            return 105;
        }
        if ((bRecv & 0x80) == 128) {
            return 112;
        }
        return 0;
    }
}

