/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core.models;

import org.vudroid.core.events.BringUpZoomControlsEvent;
import org.vudroid.core.events.EventDispatcher;
import org.vudroid.core.events.ZoomChangedEvent;
import org.vudroid.core.events.ZoomListener;

public class ZoomModel
extends EventDispatcher {
    private float zoom = 1.0f;
    private static final float INCREMENT_DELTA = 0.05f;
    private boolean horizontalScrollEnabled;
    private boolean isCommited;

    public void setZoom(float zoom) {
        if (this.zoom != (zoom = Math.max(zoom, 1.0f))) {
            float oldZoom = this.zoom;
            this.zoom = zoom;
            this.isCommited = false;
            this.dispatch(new ZoomChangedEvent(zoom, oldZoom));
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void increaseZoom() {
        this.setZoom(this.getZoom() + 0.05f);
    }

    public void decreaseZoom() {
        this.setZoom(this.getZoom() - 0.05f);
    }

    public void toggleZoomControls() {
        this.dispatch(new BringUpZoomControlsEvent());
    }

    public void setHorizontalScrollEnabled(boolean horizontalScrollEnabled) {
        this.horizontalScrollEnabled = horizontalScrollEnabled;
    }

    public boolean isHorizontalScrollEnabled() {
        return this.horizontalScrollEnabled;
    }

    public boolean canDecrement() {
        return this.zoom > 1.0f;
    }

    public void commit() {
        if (!this.isCommited) {
            this.isCommited = true;
            this.dispatch(new ZoomListener.CommitZoomEvent());
        }
    }
}

