/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core.presentation;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BrowserAdapter
extends BaseAdapter {
    private final Context context;
    private File currentDirectory;
    private List<File> files = Collections.emptyList();
    private final FileFilter filter;

    public BrowserAdapter(Context context, FileFilter filter) {
        this.context = context;
        this.filter = filter;
    }

    public int getCount() {
        return this.files.size();
    }

    public File getItem(int i) {
        return this.files.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        return null;
    }

    public void setCurrentDirectory(File currentDirectory) {
        File[] fileArray = currentDirectory.listFiles(this.filter);
        ArrayList<File> files = new ArrayList<File>(fileArray != null ? Arrays.asList(fileArray) : Collections.emptyList());
        this.currentDirectory = currentDirectory;
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() && o2.isFile()) {
                    return -1;
                }
                if (o1.isFile() && o2.isDirectory()) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (currentDirectory.getParentFile() != null) {
            files.add(0, currentDirectory.getParentFile());
        }
        this.setFiles(files);
    }

    public void setFiles(List<File> files) {
        this.files = files;
        this.notifyDataSetInvalidated();
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }
}

