/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.pdfdroid.codec;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import java.nio.ByteBuffer;
import org.vudroid.core.codec.CodecPage;

public class PdfPage
implements CodecPage {
    private long pageHandle;
    private long docHandle;

    private PdfPage(long pageHandle, long docHandle) {
        this.pageHandle = pageHandle;
        this.docHandle = docHandle;
    }

    @Override
    public boolean isDecoding() {
        return false;
    }

    @Override
    public void waitForDecode() {
    }

    @Override
    public int getWidth() {
        return (int)this.getMediaBox().width();
    }

    @Override
    public int getHeight() {
        return (int)this.getMediaBox().height();
    }

    @Override
    public Bitmap renderBitmap(int width, int height, RectF pageSliceBounds) {
        Matrix matrix = new Matrix();
        matrix.postScale((float)width / this.getMediaBox().width(), (float)(-height) / this.getMediaBox().height());
        matrix.postTranslate(0.0f, (float)height);
        matrix.postTranslate(-pageSliceBounds.left * (float)width, -pageSliceBounds.top * (float)height);
        matrix.postScale(1.0f / pageSliceBounds.width(), 1.0f / pageSliceBounds.height());
        return this.render(new Rect(0, 0, width, height), matrix);
    }

    static PdfPage createPage(long dochandle, int pageno) {
        return new PdfPage(PdfPage.open(dochandle, pageno), dochandle);
    }

    protected void finalize() throws Throwable {
        this.recycle();
        super.finalize();
    }

    @Override
    public synchronized void recycle() {
        if (this.pageHandle != 0L) {
            PdfPage.free(this.pageHandle);
            this.pageHandle = 0L;
        }
    }

    private RectF getMediaBox() {
        float[] box = new float[4];
        PdfPage.getMediaBox(this.pageHandle, box);
        return new RectF(box[0], box[1], box[2], box[3]);
    }

    public Bitmap render(Rect viewbox, Matrix matrix) {
        int[] mRect = new int[]{viewbox.left, viewbox.top, viewbox.right, viewbox.bottom};
        float[] matrixSource = new float[9];
        float[] matrixArray = new float[6];
        matrix.getValues(matrixSource);
        matrixArray[0] = matrixSource[0];
        matrixArray[1] = matrixSource[3];
        matrixArray[2] = matrixSource[1];
        matrixArray[3] = matrixSource[4];
        matrixArray[4] = matrixSource[2];
        matrixArray[5] = matrixSource[5];
        int width = viewbox.width();
        int height = viewbox.height();
        int[] bufferarray = new int[width * height];
        this.nativeCreateView(this.docHandle, this.pageHandle, mRect, matrixArray, bufferarray);
        return Bitmap.createBitmap((int[])bufferarray, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    private static native void getMediaBox(long var0, float[] var2);

    private static native void free(long var0);

    private static native long open(long var0, int var2);

    private static native void render(long var0, long var2, int[] var4, float[] var5, ByteBuffer var6, ByteBuffer var7);

    private native void nativeCreateView(long var1, long var3, int[] var5, float[] var6, int[] var7);
}

