/*
 * Decompiled with CFR 0.152.
 */
package com.printsdk.utils;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFImage;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.decrypt.PDFPassword;
import com.sun.pdfview.font.PDFFont;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.andpdf.nio.ByteBuffer;
import net.sf.andpdf.refs.HardReference;

public class PdfOpener {
    private PDFFile mCurrentOpenPdfFile = null;
    private static final float DEFAULT_ZOOM = 1.0f;
    public static int sPageImageWidth = 0;
    public static int sPageImageHeight = 0;
    private AsyncTask<Float, Void, Bitmap[]> mCurrentLoadPdfPagesTask = null;

    public void openPdf(File file, String password) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel channel = raf.getChannel();
        ByteBuffer bb = ByteBuffer.NEW((MappedByteBuffer)channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()));
        this.mCurrentOpenPdfFile = password == null ? new PDFFile(bb) : new PDFFile(bb, new PDFPassword(password));
        raf.close();
        channel.close();
    }

    public Bitmap getPdfPageImage(int pageNumber) {
        return this.getPdfPageImage(pageNumber, 1.0f);
    }

    public int getPdfNumPages() {
        if (this.mCurrentOpenPdfFile != null) {
            return this.mCurrentOpenPdfFile.getNumPages();
        }
        return 0;
    }

    public void loadAllPdfPageImages(final OnLoadPdfImageListener listener, float zoom) {
        if (this.mCurrentLoadPdfPagesTask != null) {
            return;
        }
        AsyncTask<Float, Void, Bitmap[]> loadTask = new AsyncTask<Float, Void, Bitmap[]>(){

            protected Bitmap[] doInBackground(Float ... params) {
                int numPages = PdfOpener.this.getPdfNumPages();
                Bitmap[] pageImages = new Bitmap[numPages];
                try {
                    try {
                        int i = 0;
                        while (i < numPages) {
                            Bitmap pageImage;
                            if (listener != null) {
                                listener.doInBackground(numPages, i + 1);
                            }
                            pageImages[i] = pageImage = PdfOpener.this.getPdfPageImage(i + 1);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        if (listener != null) {
                            listener.onErrorLoad();
                        }
                        PdfOpener.this.mCurrentLoadPdfPagesTask = null;
                    }
                }
                finally {
                    PdfOpener.this.mCurrentLoadPdfPagesTask = null;
                }
                return pageImages;
            }

            protected void onPostExecute(Bitmap[] result) {
                if (listener != null) {
                    listener.onCompleted(PdfOpener.this, result);
                }
            }

            protected void onPreExecute() {
                if (listener != null) {
                    listener.onPreLoad();
                }
            }
        };
        loadTask.execute((Object[])new Float[]{Float.valueOf(zoom)});
        this.mCurrentLoadPdfPagesTask = loadTask;
    }

    private Bitmap getPdfPageImage(int pageNumber, float zoom) {
        PDFPage mPdfPage = this.mCurrentOpenPdfFile.getPage(pageNumber, true);
        float wi = mPdfPage.getWidth();
        float hei = mPdfPage.getHeight();
        int width = sPageImageWidth == 0 ? (int)(wi * zoom) : sPageImageWidth;
        int height = sPageImageHeight == 0 ? (int)(hei * zoom) : sPageImageHeight;
        Bitmap bi = mPdfPage.getImage(width, height, null, true, true);
        return bi;
    }

    public static void init() {
        PDFImage.sShowImages = true;
        PDFPaint.s_doAntiAlias = true;
        PDFFont.sUseFontSubstitution = false;
        HardReference.sKeepCaches = false;
    }

    public static abstract class OnLoadPdfImageListener {
        protected void onCompleted(PdfOpener opener, Bitmap[] pageImages) {
        }

        protected void onPreLoad() {
        }

        protected void onErrorLoad() {
        }

        public void doInBackground(int numPages, int currentPage) {
        }
    }
}

