/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import org.vudroid.core.DecodeService;
import org.vudroid.core.DocumentView;
import org.vudroid.core.GoToPageDialog;
import org.vudroid.core.ViewerPreferences;
import org.vudroid.core.events.CurrentPageListener;
import org.vudroid.core.events.DecodingProgressListener;
import org.vudroid.core.models.CurrentPageModel;
import org.vudroid.core.models.DecodingProgressModel;
import org.vudroid.core.models.ZoomModel;
import org.vudroid.core.views.PageViewZoomControls;

public abstract class BaseViewerActivity
extends Activity
implements DecodingProgressListener,
CurrentPageListener {
    private static final int MENU_EXIT = 0;
    private static final int MENU_GOTO = 1;
    private static final int MENU_FULL_SCREEN = 2;
    private static final int DIALOG_GOTO = 0;
    private static final String DOCUMENT_VIEW_STATE_PREFERENCES = "DjvuDocumentViewState";
    private DecodeService decodeService;
    private DocumentView documentView;
    private ViewerPreferences viewerPreferences;
    private Toast pageNumberToast;
    private CurrentPageModel currentPageModel;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDecodeService();
        ZoomModel zoomModel = new ZoomModel();
        DecodingProgressModel progressModel = new DecodingProgressModel();
        progressModel.addEventListener(this);
        this.currentPageModel = new CurrentPageModel();
        this.currentPageModel.addEventListener(this);
        this.documentView = new DocumentView((Context)this, zoomModel, progressModel, this.currentPageModel);
        zoomModel.addEventListener(this.documentView);
        this.documentView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.decodeService.setContentResolver(this.getContentResolver());
        this.decodeService.setContainerView(this.documentView);
        this.documentView.setDecodeService(this.decodeService);
        this.decodeService.open(this.getIntent().getData());
        this.viewerPreferences = new ViewerPreferences((Context)this);
        FrameLayout frameLayout = this.createMainContainer();
        frameLayout.addView((View)this.documentView);
        frameLayout.addView((View)this.createZoomControls(zoomModel));
        this.setFullScreen();
        this.setContentView((View)frameLayout);
        SharedPreferences sharedPreferences = this.getSharedPreferences(DOCUMENT_VIEW_STATE_PREFERENCES, 0);
        this.documentView.goToPage(sharedPreferences.getInt(this.getIntent().getData().toString(), 0));
        this.documentView.showDocument();
        this.viewerPreferences.addRecent(this.getIntent().getData());
    }

    @Override
    public void decodingProgressChanged(final int currentlyDecoding) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BaseViewerActivity.this.getWindow().setFeatureInt(5, currentlyDecoding == 0 ? 10000 : currentlyDecoding);
            }
        });
    }

    @Override
    public void currentPageChanged(int pageIndex) {
        String pageText = String.valueOf(pageIndex + 1) + "/" + this.decodeService.getPageCount();
        if (this.pageNumberToast != null) {
            this.pageNumberToast.setText((CharSequence)pageText);
        } else {
            this.pageNumberToast = Toast.makeText((Context)this, (CharSequence)pageText, (int)300);
        }
        this.pageNumberToast.setGravity(51, 0, 0);
        this.pageNumberToast.show();
        this.saveCurrentPage();
    }

    private void setWindowTitle() {
        String name = this.getIntent().getData().getLastPathSegment();
        this.getWindow().setTitle((CharSequence)name);
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.setWindowTitle();
    }

    private void setFullScreen() {
        if (this.viewerPreferences.isFullScreen()) {
            this.getWindow().requestFeature(1);
            this.getWindow().setFlags(1024, 1024);
        } else {
            this.getWindow().requestFeature(5);
        }
    }

    private PageViewZoomControls createZoomControls(ZoomModel zoomModel) {
        PageViewZoomControls controls = new PageViewZoomControls((Context)this, zoomModel);
        controls.setGravity(85);
        zoomModel.addEventListener(controls);
        return controls;
    }

    private FrameLayout createMainContainer() {
        return new FrameLayout((Context)this);
    }

    private void initDecodeService() {
        if (this.decodeService == null) {
            this.decodeService = this.createDecodeService();
        }
    }

    protected abstract DecodeService createDecodeService();

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        this.decodeService.recycle();
        this.decodeService = null;
        super.onDestroy();
    }

    private void saveCurrentPage() {
        SharedPreferences sharedPreferences = this.getSharedPreferences(DOCUMENT_VIEW_STATE_PREFERENCES, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(this.getIntent().getData().toString(), this.documentView.getCurrentPage());
        editor.commit();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 0, 0, (CharSequence)"Exit");
        menu.add(0, 1, 0, (CharSequence)"Go to page");
        MenuItem menuItem = menu.add(0, 2, 0, (CharSequence)"Full screen").setCheckable(true).setChecked(this.viewerPreferences.isFullScreen());
        this.setFullScreenMenuItemText(menuItem);
        return true;
    }

    private void setFullScreenMenuItemText(MenuItem menuItem) {
        menuItem.setTitle((CharSequence)("Full screen " + (menuItem.isChecked() ? "on" : "off")));
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 0: {
                System.exit(0);
                return true;
            }
            case 1: {
                this.showDialog(0);
                return true;
            }
            case 2: {
                item.setChecked(!item.isChecked());
                this.setFullScreenMenuItemText(item);
                this.viewerPreferences.setFullScreen(item.isChecked());
                this.finish();
                this.startActivity(this.getIntent());
                return true;
            }
        }
        return false;
    }

    protected Dialog onCreateDialog(int id) {
        switch (id) {
            case 0: {
                return new GoToPageDialog((Context)this, this.documentView, this.decodeService);
            }
        }
        return null;
    }
}

